/**************************************************************************
 *
 * Copyright 2010, 2011 BMW Car IT GmbH
 * Copyright (C) 2011 DENSO CORPORATION and Robert Bosch Car Multimedia Gmbh
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include "WLContext.h"
#include "WLEGLSurface.h"
#include "WLTouchRenderer.h"

int gRunLoop = 0;
int gNeedRedraw = 0;


static void SigFunc(int)
{
    printf("Caught signal\n");
    gRunLoop = 0;
}


#define WIDTH 1024
#define HEIGHT 768

int main(int argc, char **argv)
{
    WLContext* wlContext;
    WLEGLSurface* eglSurface;
    t_ilm_layer   layerId   = 1000;
    t_ilm_surface surfaceId = 5200;

    argc = argc; // avoid warning
    argv = argv;

    // signal handling
    signal(SIGINT,SigFunc);

    ilm_init();

    wlContext = new WLContext();
    wlContext->InitWLContext(NULL, NULL, &TouchListener);

    eglSurface = new WLEGLSurface(wlContext);
    eglSurface->CreateSurface(WIDTH, HEIGHT);
    eglSurface->CreateIlmSurface(&layerId, &surfaceId, WIDTH, HEIGHT);

    if (!InitRenderer(WIDTH, HEIGHT)){
        fprintf(stderr, "Failed to init renderer\n");
        return -1;
    }

    DrawTouches(eglSurface);

    // wait for input event
    gRunLoop = 1;
    gNeedRedraw = 0;
    while (gRunLoop){
        WaitForEvent(wlContext->GetWLDisplay());
        if (gNeedRedraw && gRunLoop){
            DrawTouches(eglSurface);
            gNeedRedraw = 0;
        }
        usleep(50);
    }

    TerminateRenderer();

    ilm_layerRemoveSurface(layerId, surfaceId);
    ilm_UpdateInputEventAcceptanceOn(surfaceId,
                                    ILM_INPUT_DEVICE_TOUCH,
                                    ILM_FALSE);
    ilm_commitChanges();
    eglSurface->DestroyIlmSurface();
    ilm_commitChanges();

    ilm_destroy();
    delete eglSurface;
    delete wlContext;

    return 0;
}
